package com.amity.socialcloud.sdk.social.data.community.membership

import com.amity.socialcloud.sdk.infra.retrofit.request.QueryOptionsRequestParams
import com.ekoapp.ekosdk.internal.api.EkoApi
import com.ekoapp.ekosdk.internal.api.dto.CommunityListQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.*
import io.reactivex.rxjava3.core.Single

class CommunityMembershipRemoteDataStore {

    fun addUsers(communityId: String, userIds: List<String>): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityMembershipApi::class)
            .flatMap {
                it.addCommunityUsers(communityId, CommunityAddUsersRequest(communityId, userIds))
            }
    }

    fun removeUsers(communityId: String, userIds: List<String>): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityMembershipApi::class)
            .flatMap {
                it.deleteCommunityUsers(communityId, CommunityRemoveUsersRequest(communityId, userIds))
            }
    }

    fun addRoles(
        communityId: String,
        roles: List<String>,
        userIds: List<String>
    ): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityMembershipApi::class)
            .flatMap {
                it.addCommunityRoles(communityId, CommunityAddRolesRequest(communityId, roles, userIds))
            }
    }

    fun removeRoles(
        communityId: String,
        roles: List<String>,
        userIds: List<String>
    ): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityMembershipApi::class)
            .flatMap {
                it.deleteCommunityRoles(communityId, CommunityRemoveRolesRequest(communityId, roles, userIds))
            }
    }

    fun banUsers(communityId: String, userIds: List<String>): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityMembershipApi::class)
            .flatMap {
                it.banCommunityUsers(communityId, CommunityBanUsersRequest(communityId, userIds))
            }

    }

    fun unbanUsers(communityId: String, userIds: List<String>): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityMembershipApi::class)
            .flatMap {
                it.unbanCommunityUsers(communityId, CommunityUnBanUsersRequest(communityId, userIds))
            }
    }

    fun queryCommunityUsers(
        communityId: String,
        memberships: List<String>? = null,
        roles: List<String>? = null,
        keyword: String? = null,
        sortBy: String? = null,
        options: QueryOptionsRequestParams
    ): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityMembershipApi::class)
            .flatMap {
                it.queryCommunityUsers(
                    communityId = communityId,
                    keyword = keyword,
                    memberships = memberships,
                    roles = roles,
                    sortBy = sortBy,
                    limit = options.limit,
                    token = options.token
                )
            }
    }

    fun searchCommunityUsers(
        communityId: String,
        keyword: String? = null,
        memberships: List<String>? = null,
        roles: List<String>? = null,
        options: QueryOptionsRequestParams
    ): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityMembershipApi::class)
            .flatMap {
                it.queryCommunityUsers(
                    communityId = communityId,
                    keyword = keyword,
                    memberships = memberships,
                    roles = roles,
                    limit = options.limit,
                    token = options.token
                )
            }
    }

}