package com.amity.socialcloud.sdk.social.data.poll

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.api.dto.EkoPollDto
import com.ekoapp.ekosdk.internal.api.mapper.EkoPollMapper
import com.ekoapp.ekosdk.internal.entity.PollEntity

internal class PollEntityMapper : EntityMapper<EkoPollDto, PollEntity>() {

    override fun map(list: List<EkoPollDto>): List<PollEntity> {
        return list.map { map(it) }
    }

    private fun map(dto: EkoPollDto) : PollEntity {
        return PollEntity().apply {
            pollId = dto.pollId
            userId = dto.userId
            question = dto.question
            answers = dto.answers
            answerType = dto.answerType
            status = dto.status
            closedAt = dto.closedAt
            isDeleted = dto.isDeleted
            isVoted = dto.isVoted
            createdAt = dto.createdAt
            updatedAt = dto.updatedAt
        }
    }

}