package com.amity.socialcloud.sdk.social.data.poll

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.social.feed.AmityPoll
import com.ekoapp.ekosdk.internal.entity.PollEntity

internal class PollModelMapper : ModelMapper<PollEntity, AmityPoll>() {

    override fun map(entity: PollEntity): AmityPoll {
        return AmityPoll(
            pollId = entity.pollId,
            userId = entity.userId,
            question = entity.question,
            answers = entity.answers,
            answerType = AmityPoll.AnswerType.fromApiKey(entity.answerType),
            status = AmityPoll.Status.fromApiKey(entity.status),
            closedAt = entity.closedAt,
            isDeleted = entity.isDeleted,
            isVoted = entity.isVoted,
            createdAt = entity.createdAt,
            updatedAt = entity.updatedAt
        )
    }
}