package com.amity.socialcloud.sdk.social.data.poll

import com.amity.socialcloud.sdk.social.feed.AmityPoll
import com.amity.socialcloud.sdk.social.feed.AmityPollAnswer
import com.ekoapp.ekosdk.internal.api.EkoApi
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.dto.EkoPollQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.PollCreateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.PollUpdateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.PollVoteRequest
import io.reactivex.rxjava3.core.Single

internal class PollRemoteDataStore {

    fun createPoll(
        question: String,
        answers: List<AmityPollAnswer.Data>,
        answerType: String,
        closedIn: Long?
    ): Single<EkoPollQueryDto> {
        return EkoApi.get(PollApi::class)
            .flatMap {
                it.createPoll( PollCreateRequest(
                    question = question,
                    answers = PollRepositoryHelper().convertAnswersToJsonArray(answers),
                    answerType = answerType,
                    closedIn = closedIn
                ))
            }
    }

    fun closePoll(pollId: String): Single<EkoPollQueryDto> {
        return EkoApi.get(PollApi::class)
            .flatMap {
                it.updatePoll(pollId, PollUpdateRequest(status = AmityPoll.Status.CLOSED.apiKey))
            }
    }

    fun deletePoll(pollId: String): Single<EkoDeletionDto> {
        return EkoApi.get(PollApi::class)
            .flatMap {
                it.deletePoll(pollId)
            }
    }

    fun vote(pollId: String, answerIds: List<String>): Single<EkoPollQueryDto> {
        return EkoApi.get(PollApi::class)
            .flatMap {
                it.votePoll(pollId, PollVoteRequest(answerIds))

            }
    }

}