package com.amity.socialcloud.sdk.social.data.post

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.PostEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoPostDto
import com.ekoapp.ekosdk.internal.api.mapper.EkoPostMapper
import com.ekoapp.ekosdk.internal.data.model.AmityReactionMap

internal class PostEntityMapper : EntityMapper<EkoPostDto, PostEntity>() {

    override fun map(list: List<EkoPostDto>): List<PostEntity> {
        return list.map {
            map(it)
        }
    }

    private fun map(dto: EkoPostDto): PostEntity {
        return PostEntity().apply {
            postId = dto.postId
            path = dto.path
            targetType = dto.targetType
            targetId = dto.targetId
            parentPostId = dto.parentPostId
            postedUserId = dto.postedUserId
            sharedUserId = dto.sharedUserId
            postDataType = dto.dataType
            data = dto.data
            metadata = dto.metadata
            sharedCount = dto.sharedCount
            reactions = if (dto.reactions == null) AmityReactionMap() else dto.reactions
            reactionCount = dto.reactionCount
            flagCount = dto.flagCount
            commentCount = dto.commentsCount
            childPostIds = dto.children
            isDeleted = dto.deleted
            feedType = dto.feedType
            editedAt = dto.editedAt
            setCreatedAt(dto.createdAt)
            setUpdatedAt(dto.updatedAt)
            if (dto.mentionees != null) {
                mentionees = dto.mentionees
            }
        }
    }

}