package com.amity.socialcloud.sdk.social.data.post

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.reaction.ReactionLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType
import com.amity.socialcloud.sdk.social.data.category.CategoryEntityMapper
import com.amity.socialcloud.sdk.social.data.category.CategoryLocalDataStore
import com.amity.socialcloud.sdk.social.data.comment.CommentEntityMapper
import com.amity.socialcloud.sdk.social.data.comment.CommentLocalDataStore
import com.amity.socialcloud.sdk.social.data.comment.flag.CommentFlagEntityMapper
import com.amity.socialcloud.sdk.social.data.comment.flag.CommentFlagLocalDataStore
import com.amity.socialcloud.sdk.social.data.comment.reaction.CommentReactionEntityMapper
import com.amity.socialcloud.sdk.social.data.community.CommunityEntityMapper
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipLocalDataStore
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipEntityMapper
import com.amity.socialcloud.sdk.social.data.feed.FeedEntityMapper
import com.amity.socialcloud.sdk.social.data.feed.FeedLocalDataStore
import com.amity.socialcloud.sdk.social.data.poll.PollEntityMapper
import com.amity.socialcloud.sdk.social.data.poll.PollLocalDataStore
import com.amity.socialcloud.sdk.social.data.post.flag.PostFlagEntityMapper
import com.amity.socialcloud.sdk.social.data.post.flag.PostFlagLocalDataStore
import com.amity.socialcloud.sdk.social.data.post.reaction.PostReactionEntityMapper
import com.amity.socialcloud.sdk.social.feed.AmityFeedType
import com.amity.socialcloud.sdk.video.data.stream.StreamEntityMapper
import com.amity.socialcloud.sdk.video.data.stream.StreamLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto
import io.reactivex.rxjava3.core.Completable


class PostQueryPersister : QueryPersister<EkoPostQueryDto>() {

    override fun persist(dto: EkoPostQueryDto): Completable {
        val feedTypes = mutableMapOf<String, String>()
        dto.feeds.forEach {
            it.feedId ?: return@forEach
            it.feedType ?: return@forEach
            feedTypes[it.feedId] = it.feedType
        }
        dto.children.forEach {
            it.feedType = feedTypes[it.feedId] ?: AmityFeedType.PUBLISHED.apiKey
        }
        dto.posts.forEach {
            it.feedType = feedTypes[it.feedId] ?: AmityFeedType.PUBLISHED.apiKey
        }
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users)))
            .andThen(UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(dto.users)))
            .andThen(CategoryLocalDataStore().saveCategories(CategoryEntityMapper().map(dto.categories)))
            .andThen(CommunityMembershipLocalDataStore().saveMemberships(CommunityMembershipEntityMapper().map(dto.communityUsers)))
            .andThen(CommunityLocalDataStore().saveCommunities(CommunityEntityMapper().map(dto.communities)))
            .andThen(CommentLocalDataStore().saveComments(CommentEntityMapper().map(dto.comments)))
            .andThen(CommentFlagLocalDataStore().saveFlags(CommentFlagEntityMapper().map(dto.comments)))
            .andThen(ReactionLocalDataStore().saveReactionsAndDeletePrevious(ReactionReferenceType.COMMENT, dto.comments.map { it.commentId }, CommentReactionEntityMapper().map(dto.comments)))
            .andThen(PostLocalDataStore().savePosts(PostEntityMapper().map(dto.children)))
            .andThen(PostFlagLocalDataStore().saveFlags(PostFlagEntityMapper().map(dto.children)))
            .andThen(ReactionLocalDataStore().saveReactionsAndDeletePrevious(ReactionReferenceType.POST, dto.children.map { it.postId }, PostReactionEntityMapper().map(dto.children)))
            .andThen(PostLocalDataStore().savePosts(PostEntityMapper().map(dto.posts)))
            .andThen(PostFlagLocalDataStore().saveFlags(PostFlagEntityMapper().map(dto.posts)))
            .andThen(ReactionLocalDataStore().saveReactionsAndDeletePrevious(ReactionReferenceType.POST, dto.posts.map { it.postId }, PostReactionEntityMapper().map(dto.posts)))
            .andThen(FeedLocalDataStore().saveFeeds(FeedEntityMapper().map(dto.feeds)))
            .andThen(StreamLocalDataStore().saveStream(StreamEntityMapper().map(dto.streams)))
            .andThen(PollLocalDataStore().savePolls(PollEntityMapper().map(dto.polls)))

    }

}