package com.amity.socialcloud.sdk.social.data.post.reaction

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType
import com.ekoapp.ekosdk.internal.api.dto.EkoPostDto
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity

internal class PostReactionEntityMapper : EntityMapper<EkoPostDto, EkoReactionEntity>() {

    override fun map(list: List<EkoPostDto>): List<EkoReactionEntity> {
        val reactions = mutableListOf<EkoReactionEntity>()
        list.forEach {
            val reactionNames = it.myReactions?.map { reactionName ->
                ReactionRepository().createMyReaction(
                    ReactionReferenceType.POST,
                    it.postId,
                    reactionName!!
                )
            }
            reactionNames?.let {
                reactions.addAll(it)
            }
        }
        return reactions
    }
}