package com.amity.socialcloud.sdk.social.domain.comment

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.reaction.MyReactionsGetUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.core.mention.AmityMentionee
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType
import com.amity.socialcloud.sdk.social.comment.AmityComment
import com.amity.socialcloud.sdk.social.domain.comment.flag.IsCommentFlaggedByMeUseCase

internal class CommentComposerUseCase: ComposerUseCase() {

    fun execute(comment: AmityComment): AmityComment {
        addLatestReplies(comment)
        addMyReactions(comment)
        addMyFlag(comment)
        addCommentUser(comment)
        addMentioneeUser(comment)
        return comment
    }

    private fun addMyReactions(comment: AmityComment) {
        comment.myReactions =
            MyReactionsGetUseCase().execute(ReactionReferenceType.COMMENT, comment.getCommentId())
    }

    private fun addMyFlag(comment: AmityComment) {
        comment.isFlaggedByMe = IsCommentFlaggedByMeUseCase().execute(comment.getCommentId())
    }

    private fun addCommentUser(comment: AmityComment) {
        comment.user = UserGetUseCase().execute(comment.getUserId())
    }

    private fun addMentioneeUser(comment: AmityComment) {
        comment.mentionees = comment.getMentionees().map {
            if (it is AmityMentionee.USER) {
                it.user = UserGetUseCase().execute(it.getUserId())
            }
            it
        }
    }

    private fun addLatestReplies(comment: AmityComment) {
        comment.latestReplies = LatestRepliesGetUseCase().execute(
            referenceType = comment.referenceType,
            referenceId = comment.referenceId,
            parentId = comment.getCommentId(),
        )
    }

}