package com.amity.socialcloud.sdk.social.domain.community

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.social.domain.category.CategoryGetUseCase
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.social.community.AmityCommunity

internal class CommunityComposerUseCase : ComposerUseCase() {

    fun execute(community: AmityCommunity): AmityCommunity {
        UserGetUseCase().execute(community.getUserId())?.let {
            community.user = it
        }
        ImageGetUseCase().execute(community.getAvatarFileId())?.let {
            community.avatarImage = it
        }
        CategoryGetUseCase().execute(community.getCategoryIds()).let {
            community.categories = it
        }
        return community
    }
}