package com.amity.socialcloud.sdk.video.data.stream

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.EkoStreamQueryDto
import io.reactivex.rxjava3.core.Completable

internal class StreamListQueryPersister : QueryPersister<EkoStreamQueryDto>() {

    override fun persist(dto: EkoStreamQueryDto): Completable {
       return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.result.files))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.result.users)))
            .andThen(UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(dto.result.users)))
            .andThen(StreamLocalDataStore().saveStream(StreamEntityMapper().map(dto.result.streams)))
    }

}