package com.amity.socialcloud.sdk.video.data.stream

import androidx.annotation.WorkerThread
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.entity.EkoStreamEntity

internal class StreamRepositoryHelper {

    @WorkerThread
    fun attachDataToEntity(entity: EkoStreamEntity): EkoStreamEntity {
        entity.thumbnailFileId?.let {
            val fileDao = UserDatabase.get().fileDao()
            fileDao.getByIdNow(it)?.let(entity::setThumbnailFile)
        }

        entity.userId?.let {
            val userDao = UserDatabase.get().userDao()
            userDao.getByIdNow(it)?.let(entity::setUser)
        }

        return entity
    }
}