package com.ekoapp.core.utils

import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import io.reactivex.Completable as CompletableV2
import io.reactivex.Single as SingleV2
import io.reactivex.rxjava3.core.Completable as CompletableV3
import io.reactivex.rxjava3.core.Single as SingleV3

suspend fun CompletableV3.toSuspend(dispatcher: CoroutineDispatcher = Dispatchers.IO) {
    withContext(dispatcher) {
        this@toSuspend.blockingAwait()
    }
}

@Deprecated("Rx2 will be obsoleted soon, please upgrade to Rx3 instead")
suspend fun CompletableV2.toSuspend(dispatcher: CoroutineDispatcher = Dispatchers.IO) {
    withContext(dispatcher) {
        this@toSuspend.blockingAwait()
    }
}

suspend fun <T : Any> SingleV3<T>.toSuspend(dispatcher: CoroutineDispatcher = Dispatchers.IO): T {
    return withContext(dispatcher) {
        this@toSuspend.blockingGet()
    }
}

@Deprecated("Rx2 will be obsoleted soon, please upgrade to Rx3 instead")
suspend fun <T : Any> SingleV2<T>.toSuspend(dispatcher: CoroutineDispatcher = Dispatchers.IO): T {
    return withContext(dispatcher) {
        this@toSuspend.blockingGet()
    }
}