package com.ekoapp.core.utils

import com.amity.socialcloud.sdk.core.permission.AmityPermissions
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.google.gson.JsonObject
import org.joda.time.DateTime

/**
 * For property that use @JvmOverloads for remove property from data class
 */
internal fun requiredNotEmpty(value: String): String? = if (value.isNotEmpty()) value else null

internal fun requiredNonNull(value: String?): String = value ?: ""

internal fun requiredNonNull(value: Int?): Int = value ?: 0

internal fun requiredNonNull(value: Boolean?): Boolean = value ?: false

internal fun requiredNonNull(value: AmityRoles?): AmityRoles = value ?: AmityRoles()

internal fun requiredNonNull(value: AmityPermissions?): AmityPermissions = value ?: AmityPermissions()

internal fun requiredNonNull(value: JsonObject?): JsonObject = value ?: JsonObject()

internal fun requiredNonNull(value: DateTime?): DateTime = value ?: DateTime.now()