package com.ekoapp.core.utils

import hu.akarnokd.rxjava3.bridge.RxJavaBridge
import io.reactivex.Completable as CompletableV2
import io.reactivex.Flowable as FlowableV2
import io.reactivex.Maybe as MaybeV2
import io.reactivex.Single as SingleV2
import io.reactivex.rxjava3.core.Completable as CompletableV3
import io.reactivex.rxjava3.core.Flowable as FlowableV3
import io.reactivex.rxjava3.core.Maybe as MaybeV3
import io.reactivex.rxjava3.core.Single as SingleV3


fun CompletableV3.toV2(): CompletableV2 {
    return this.to(RxJavaBridge.toV2Completable())
}

fun CompletableV2.toV3(): CompletableV3 {
    return this.`as`(RxJavaBridge.toV3Completable())
}

fun <T : Any> SingleV3<T>.toV2(): SingleV2<T> {
    return this.to(RxJavaBridge.toV2Single())
}

fun <T : Any> SingleV2<T>.toV3(): SingleV3<T> {
    return this.`as`(RxJavaBridge.toV3Single())
}

fun <T : Any> FlowableV3<T>.toV2(): FlowableV2<T> {
    return this.to(RxJavaBridge.toV2Flowable())
}

fun <T : Any> FlowableV2<T>.toV3(): FlowableV3<T> {
    return this.`as`(RxJavaBridge.toV3Flowable())
}

fun <T : Any> MaybeV3<T>.toV2(): MaybeV2<T> {
    return this.to(RxJavaBridge.toV2Maybe())
}

fun <T : Any> MaybeV2<T>.toV3(): MaybeV3<T> {
    return this.`as`(RxJavaBridge.toV3Maybe())
}