package com.amity.socialcloud.sdk.chat.channel

import com.amity.socialcloud.sdk.chat.domain.channel.TotalChannelUnreadCountUseCase
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.channel.*
import io.reactivex.Completable
import io.reactivex.Flowable
import io.reactivex.Single

class AmityChannelRepository internal constructor() {

    fun createChannel(): AmityChannelCreatorTypeSelection {
        return AmityChannelCreatorTypeSelection()
    }

    fun getChannels(): AmityChannelQueryBuilder {
        return AmityChannelQueryBuilder()
    }

    @Deprecated(
        message = "duplicated with getChannel(channelId: String)",
        replaceWith = ReplaceWith("getChannel(channelId: String)"),
        level = DeprecationLevel.WARNING
    )
    fun fetchChannel(channelId: String): Completable {
        return FetchChannelUseCase().execute(channelId).toV2()
    }

    @Deprecated(
        message = "duplicated with getChannel(channelId: String)",
        replaceWith = ReplaceWith("getChannel(channelId: String)"),
        level = DeprecationLevel.WARNING
    )
    fun observeChannel(channelId: String): Flowable<AmityChannel> {
        return ObserveChannelUseCase().execute(channelId).toV2()
    }

    fun getChannel(channelId: String): Flowable<AmityChannel> {
        return ChannelLiveObjectUseCase().execute(channelId).toV2()
    }

    fun joinChannel(channelId: String): Single<AmityChannel> {
        return JoinChannelUseCase().execute(channelId).toV2()
    }

    fun leaveChannel(channelId: String): Completable {
        return LeaveChannelUseCase().execute(channelId).toV2()
    }

    fun updateChannel(channelId: String): AmityChannelWithChannelIdUpdate.Builder {
        return AmityChannelWithChannelIdUpdate
                .Builder(channelId)
    }

    fun getTotalUnreadCount(): Flowable<Int> {
        return TotalChannelUnreadCountUseCase().execute().toV2()
    }

    fun membership(channelId: String): AmityChannelParticipation {
        return AmityChannelParticipation(channelId)
    }

    fun moderation(channelId: String): AmityChannelModeration {
        return AmityChannelModeration(channelId)
    }

    fun notification(channelId: String): AmityChannelNotification {
        return AmityChannelNotification(channelId)
    }

}