package com.amity.socialcloud.sdk.social.comment

import com.amity.socialcloud.sdk.core.ExperimentalAmityApi
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.comment.DeleteCommentUseCase
import com.ekoapp.ekosdk.internal.usecase.comment.ObserveSingleCommentUseCase
import io.reactivex.Completable
import io.reactivex.Flowable

class AmityCommentRepository internal constructor() {

    @ExperimentalAmityApi
    fun observeComment(commentId: String): Flowable<AmityComment> {
        return ObserveSingleCommentUseCase().execute(commentId).toV2()
    }

    fun getComments(): AmityCommentQueryTypeSelector {
        return AmityCommentQueryTypeSelector()
    }

    fun createComment(): AmityCommentCreateTargeter {
        return AmityCommentCreateTargeter()
    }

    @Deprecated("commentId can be autogenerated", ReplaceWith("createComment()"), DeprecationLevel.WARNING)
    fun createComment(commentId: String): AmityCommentCreateTargeter {
        return AmityCommentCreateTargeter(commentId)
    }

    fun deleteComment(commentId: String): Completable {
        return deleteComment(commentId, false)
    }

    fun deleteComment(commentId: String, hardDelete: Boolean): Completable {
        return DeleteCommentUseCase().execute(commentId, hardDelete).toV2()
    }

    fun getReactions(commentId: String): AmityCommentReactionQuery.Builder {
        return AmityCommentReactionQuery.Builder(commentId)
    }

    fun getLatestComment(): AmityLatestCommentQueryTypeSelector {
        return AmityLatestCommentQueryTypeSelector()
    }

}