package com.amity.socialcloud.sdk.social.community

import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.community.*
import io.reactivex.Completable
import io.reactivex.Flowable

class AmityCommunityRepository internal constructor() {

    fun createCommunity(displayName: String): AmityCommunityWithDisplayNameCreateByAdmin.Builder {
        return AmityCommunityWithDisplayNameCreateByAdmin.Builder(displayName)
    }

    fun getCommunities(): AmityCommunityQueryWithKeywordBuilder.Builder {
        return AmityCommunityQueryWithKeywordBuilder.Builder()
    }

    fun getRecommendedCommunities(): Flowable<List<AmityCommunity>> {
        return RecommendedCommunityQueryUseCase().execute().toV2()
    }

    fun getTrendingCommunities(): Flowable<List<AmityCommunity>> {
        return TrendingCommunityQueryUseCase().execute().toV2()
    }

    fun membership(communityId: String): AmityCommunityParticipation {
        return AmityCommunityParticipation(communityId)
    }

    fun getCommunity(communityId: String): Flowable<AmityCommunity> {
        return CommunityLiveObjectUseCase().execute(communityId).toV2()
    }

    fun getCategories(): AmityCommunityCategoryQuery.Builder {
        return AmityCommunityCategoryQuery.Builder()
    }

    fun deleteCommunity(communityId: String): Completable {
        return DeleteCommunityUseCase().execute(communityId).toV2()
    }

    fun updateCommunity(communityId: String): AmityCommunityWithCommunityIdByAdminUpdate.Builder {
        return AmityCommunityWithCommunityIdByAdminUpdate.Builder(communityId)
    }

    fun joinCommunity(communityId: String): Completable {
        return JoinCommunityUseCase().execute(communityId).toV2()
    }

    fun leaveCommunity(communityId: String): Completable {
        return LeaveCommunityUseCase().execute(communityId).toV2()
    }

    fun moderation(communityId: String): AmityCommunityModeration {
        return AmityCommunityModeration(communityId)
    }

    fun notification(communityId: String): AmityCommunityNotification {
        return AmityCommunityNotification(communityId)
    }

}