package com.ekoapp.ekosdk

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.google.gson.JsonObject
import kotlinx.android.parcel.Parcelize
import kotlinx.android.parcel.TypeParceler

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityContentCheck(private val feedTypes: List<FeedType> = emptyList()) : Parcelable {
	
	fun post(): FeedType? {
		return feedTypes.firstOrNull { it.feedType == AmityContentFeedType.POST }
	}
	
	fun message(): FeedType? {
		return feedTypes.firstOrNull { it.feedType == AmityContentFeedType.MESSAGE }
	}
	
	@Parcelize
	@TypeParceler<JsonObject?, JsonObjectParceler>
	data class FeedType(
		val feedType: AmityContentFeedType,
		val text: Content.TEXT? = null,
		val video: Content.VIDEO? = null
	) : Parcelable {
		
		sealed class Content : Parcelable {
			
			@Parcelize
			@TypeParceler<JsonObject?, JsonObjectParceler>
			data class TEXT(
				val allowed: Boolean
			) : Content()
			
			@Parcelize
			@TypeParceler<JsonObject?, JsonObjectParceler>
			data class VIDEO(
				val allowed: Boolean,
				val minResolution: AmityVideoResolution?,
				val maxResolution: AmityVideoResolution?,
				val minDurationSeconds: Int?,
				val maxDurationSeconds: Int?
			) : Content()
		}
	}
}