package com.amity.socialcloud.sdk.social.feed

import com.amity.socialcloud.sdk.AmityCoreClient
import com.amity.socialcloud.sdk.core.reaction.AmityPostReactionQuery
import com.amity.socialcloud.sdk.social.AmitySocialClient
import com.amity.socialcloud.sdk.social.comment.AmityCommentQuery
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.feed.review.AmityPostReviewer
import com.ekoapp.ekosdk.internal.usecase.post.PostDeleteUseCase
import com.ekoapp.ekosdk.internal.usecase.post.PostLiveObjectUseCase
import io.reactivex.Completable
import io.reactivex.Flowable

class AmityFeedRepository internal constructor() {

    fun getGlobalFeed(): AmityGlobalFeedQuery.Builder {
        return AmityGlobalFeedQuery.Builder()
    }

    fun getCustomRankingGlobalFeed(): AmityCustomRankingGlobalFeedQuery.Builder {
        return AmityCustomRankingGlobalFeedQuery.Builder()
    }

    fun getCommunityFeed(communityId: String): AmityCommunityFeedQuery.Builder {
        return AmityCommunityFeedQuery.Builder(communityId)
    }

    fun getUserFeed(userId: String): AmityUserFeedQuery.Builder {
        return AmityUserFeedQuery.Builder(userId)
    }

    fun getMyFeed(): AmityUserFeedQuery.Builder {
        return AmityUserFeedQuery.Builder(AmityCoreClient.getUserId())
    }

    @Deprecated("Moved to AmityPostRepository")
    fun getPost(postId: String): Flowable<AmityPost> {
        return PostLiveObjectUseCase().execute(postId).toV2()
    }

    @Deprecated("Moved to AmityPostRepository")
    fun createPost(): AmityPostCreateTargetSelector {
        return AmityPostCreateTargetSelector()
    }

    @Deprecated("Moved to AmityPostRepository")
    fun deletePost(postId: String): Completable {
        return PostDeleteUseCase().execute(postId, false).toV2()
    }

    @Deprecated("Moved to AmityPostRepository")
    fun reviewPost(postId: String): AmityPostReviewer {
        return AmityPostReviewer(postId)
    }

    @Deprecated("Moved to AmityPostRepository")
    fun getReactions(postId: String): AmityPostReactionQuery.Builder {
        return AmityPostReactionQuery.Builder(postId)
    }

    @Deprecated("Moved to AmityPostRepository")
    fun getComments(postId: String): AmityCommentQuery.Builder {
        return AmitySocialClient.newCommentRepository().getComments().post(postId)
    }

}
