package com.amity.socialcloud.sdk.core.file

import android.net.Uri
import co.amity.rxupload.RxUploadService
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.AmityContentFeedType
import io.reactivex.Flowable

class AmityFileRepository {

    fun uploadFile(uri: Uri): AmityFileUploadService.Builder {
        return AmityFileUploadService.Builder().fileUri(uri)
    }

    fun uploadImage(uri: Uri): AmityImageUploadService.Builder {
        return AmityImageUploadService.Builder().fileUri(uri)
    }

    fun uploadAudio(uri: Uri): AmityAudioUploadService.Builder {
        return AmityAudioUploadService.Builder().fileUri(uri)
    }

    @Deprecated("Please use uploadVideo(uri: Uri, feedType: AmityContentFeedType instead")
    fun uploadVideo(uri: Uri): AmityVideoUploadService.Builder {
        return AmityVideoUploadService.Builder()
                .fileUri(uri)
    }
    
    fun uploadVideo(uri: Uri, feedType: AmityContentFeedType): AmityVideoUploadService.Builder {
        return AmityVideoUploadService.Builder()
                .fileUri(uri).apply {
                    feedType.let(::feedType)
                }
    }

    fun cancelUpload(uploadId: String) {
        RxUploadService.cancel(uploadId)
    }

    fun getUploadInfo(uploadId: String): Flowable<AmityUploadInfo> {
        return RxUploadService.properties(uploadId)
                .map { AmityUploadInfo(it) }.toV2()
    }

}