package com.amity.socialcloud.sdk.chat

import com.amity.socialcloud.sdk.chat.message.AmityMessage
import com.amity.socialcloud.sdk.chat.message.AmityMessageCreateTargeter
import com.amity.socialcloud.sdk.chat.message.AmityMessageQuery
import com.amity.socialcloud.sdk.core.reaction.AmityMessageReactionQuery
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.message.MessageLiveObjectUseCase
import com.ekoapp.ekosdk.internal.usecase.message.MessageDeleteUseCase
import io.reactivex.Completable
import io.reactivex.Flowable


class AmityMessageRepository internal constructor() {

    fun getMessages(channelId: String): AmityMessageQuery.Builder {
        return AmityMessageQuery.Builder().channelId(channelId)
    }

    fun getMessage(messageId: String): Flowable<AmityMessage> {
        return MessageLiveObjectUseCase().execute(messageId).toV2()
    }

    fun createMessage(channelId: String): AmityMessageCreateTargeter.Builder {
        return AmityMessageCreateTargeter.Builder().channelId(channelId)
    }

    fun deleteMessage(messageId: String): Completable {
        return MessageDeleteUseCase().execute(messageId).toV2()
    }

    fun getReactions(messageId: String): AmityMessageReactionQuery.Builder {
        return AmityMessageReactionQuery.Builder(messageId)
    }
}