package com.amity.socialcloud.sdk.core.permission

import android.os.Parcelable
import kotlinx.android.parcel.Parcelize

@Parcelize
class AmityPermissions(private val permissions: List<String>) : ArrayList<String>(permissions), Parcelable {

    constructor() : this(mutableListOf())

    constructor(permissions: Set<String>) : this(permissions.toList())

    fun get() : List<String> {
        return this.filter { it.isNotEmpty() }
    }

}