package com.amity.socialcloud.sdk.social.post

import com.amity.socialcloud.sdk.social.feed.AmityPoll
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.post.PollCloseUseCase
import com.ekoapp.ekosdk.internal.usecase.post.PollDeleteUseCase
import com.ekoapp.ekosdk.internal.usecase.post.PollGetUseCase
import com.ekoapp.ekosdk.internal.usecase.post.PollVoteUseCase
import io.reactivex.Completable
import io.reactivex.Flowable

class AmityPollRepository internal constructor() {

    fun createPoll(question: String): AmityPollBuilder.Builder {
        return AmityPollBuilder.Builder(question)
    }

    fun getPoll(pollId: String): Flowable<AmityPoll> {
        return PollGetUseCase().execute(pollId).toV2()
    }

    fun closePoll(pollId: String): Completable {
        return PollCloseUseCase().execute(pollId).toV2()
    }

    fun deletePoll(pollId: String): Completable {
        return PollDeleteUseCase().execute(pollId).toV2()
    }

    fun vote(pollId: String, answerIds: List<String>): Completable {
        return PollVoteUseCase().execute(pollId, answerIds).toV2()
    }
}