package com.amity.socialcloud.sdk.social.feed

import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.report.AmityFlagType
import com.ekoapp.ekosdk.internal.report.AmityFlagger
import com.ekoapp.ekosdk.internal.usecase.post.FlagPostUseCase
import com.ekoapp.ekosdk.internal.usecase.post.UnFlagPostUseCase
import io.reactivex.Completable

class AmityPostFlagger internal constructor(private val postId: String) : AmityFlagger() {

    private fun flag(vararg flagTypes: AmityFlagType): Completable {
        return FlagPostUseCase().execute(postId, *flagTypes).toV2()
    }

    private fun unflag(vararg flagTypes: AmityFlagType): Completable {
        return UnFlagPostUseCase().execute(postId, *flagTypes).toV2()
    }

    fun flag(): Completable {
        return flag(AmityFlagType.SPAM)
    }

    fun unflag(): Completable {
        return unflag(AmityFlagType.SPAM)
    }

}