package com.amity.socialcloud.sdk.social.post

import com.amity.socialcloud.sdk.core.reaction.AmityPostReactionQuery
import com.amity.socialcloud.sdk.social.AmitySocialClient
import com.amity.socialcloud.sdk.social.comment.AmityCommentQuery
import com.amity.socialcloud.sdk.social.domain.post.getbyids.PostGetByIdsUseCase
import com.amity.socialcloud.sdk.social.feed.AmityPost
import com.amity.socialcloud.sdk.social.feed.AmityPostCreateTargetSelector
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.feed.review.AmityPostReviewer
import com.ekoapp.ekosdk.internal.usecase.post.PostDeleteUseCase
import com.ekoapp.ekosdk.internal.usecase.post.PostLiveObjectUseCase
import io.reactivex.Completable
import io.reactivex.Flowable

class AmityPostRepository internal constructor() {


    fun getPost(postId: String): Flowable<AmityPost> {
        return PostLiveObjectUseCase().execute(postId).toV2()
    }

    fun getPosts(): AmityPostQueryTargetSelector {
        return AmityPostQueryTargetSelector()
    }

    fun createPost(): AmityPostCreateTargetSelector {
        return AmityPostCreateTargetSelector()
    }

    fun deletePost(postId: String): Completable {
        return deletePost(postId, false)
    }

    fun deletePost(postId: String, hardDelete: Boolean): Completable {
        return PostDeleteUseCase().execute(postId, hardDelete).toV2()
    }

    fun reviewPost(postId: String): AmityPostReviewer {
        return AmityPostReviewer(postId)
    }

    fun getReactions(postId: String): AmityPostReactionQuery.Builder {
        return AmityPostReactionQuery.Builder(postId)
    }

    fun getComments(postId: String): AmityCommentQuery.Builder {
        return AmitySocialClient.newCommentRepository().getComments().post(postId)
    }
    
    fun getPostByIds(postIds: Set<String>): Flowable<List<AmityPost>> {
        return PostGetByIdsUseCase().execute(postIds).toV2()
    }

}
