package com.amity.socialcloud.sdk.video


import com.amity.socialcloud.sdk.video.model.AmityBroadcastResolution
import com.amity.socialcloud.sdk.video.stream.AmityStream
import com.amity.socialcloud.sdk.video.stream.AmityStreamQuery
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.stream.CreateStreamUseCase
import com.ekoapp.ekosdk.internal.usecase.stream.FetchStreamUseCase
import com.ekoapp.ekosdk.internal.usecase.stream.ObserveStreamUseCase
import io.reactivex.Completable
import io.reactivex.Flowable
import io.reactivex.Single

class AmityStreamRepository internal constructor() {

    fun getStreams(): AmityStreamQuery.Builder {
        return AmityStreamQuery.Builder()
    }

    @Deprecated("Please use observeStream(streamId: String) instead")
    fun getStream(streamId: String): Flowable<AmityStream> {
        return observeStream(streamId)
    }

    fun fetchStream(streamId: String): Completable {
        return FetchStreamUseCase().execute(streamId).toV2()
    }

    fun observeStream(streamId: String): Flowable<AmityStream> {
        return ObserveStreamUseCase().execute(streamId).toV2()
    }

    fun createVideoStream(
        title: String,
        description: String,
        resolution: AmityBroadcastResolution,
        thumbnailFileId: String? = null
    ): Single<AmityStream> {
        return CreateStreamUseCase().execute(
            title = title,
            description = description,
            resolution = resolution,
            thumbnailFileId = thumbnailFileId
        ).toV2()
    }
}