package com.amity.socialcloud.sdk.core.user

import com.amity.socialcloud.sdk.AmityCoreClient
import com.amity.socialcloud.sdk.core.flag.AmityUserFlagger
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.user.UserLiveObjectUseCase
import io.reactivex.Flowable

class AmityUserRepository internal constructor() {

    fun getUsers(): AmityAllUsersQuery.Builder {
        return AmityAllUsersQuery.Builder()
    }

    fun searchUserByDisplayName(keyword: String): AmityUserSearchByDisplayName.Builder {
        return AmityUserSearchByDisplayName.Builder().keyword(keyword)
    }

    fun getUser(userId: String): Flowable<AmityUser> {
        return UserLiveObjectUseCase().execute(userId).toV2()
    }

    fun getCurrentUser(): Flowable<AmityUser> {
        return getUser(AmityCoreClient.getUserId())
    }

    fun report(userId: String): AmityUserFlagger {
        return AmityUserFlagger(userId)
    }

    fun relationship(): AmityUserRelationships {
        return AmityUserRelationships()
    }
}