package com.ekoapp.ekosdk

import androidx.paging.DataSource
import androidx.paging.PagedList
import androidx.paging.PagedList.BoundaryCallback
import androidx.paging.RxPagedListBuilder
import io.reactivex.BackpressureStrategy
import io.reactivex.Flowable

@Deprecated(
    message = "PagedList already discontinued on this project",
    replaceWith = ReplaceWith(expression = "AmityObjectRepository")
)
internal abstract class EkoObjectRepository {

    companion object {
        const val INITIAL_LOAD_KEY_VALUE = 0
        const val DEFAULT_PAGE_SIZE = 15
    }

    private fun <T : Any> createRxCollectionBuilder(factory: DataSource.Factory<Int, T>, enablePlaceholders: Boolean)
            : RxPagedListBuilder<Int, T> {
        val config = PagedList.Config.Builder()
                .setPageSize(DEFAULT_PAGE_SIZE)
                .setEnablePlaceholders(enablePlaceholders)
                .build()
        return RxPagedListBuilder(factory, config)
    }

    fun <T : Any> createRxCollectionWithBoundaryCallback(factory: DataSource.Factory<Int, T>,
                                                         callback: BoundaryCallback<T>): Flowable<PagedList<T>> {
        return createRxCollectionWithBoundaryCallback(factory, callback, INITIAL_LOAD_KEY_VALUE)
    }

    fun <T : Any> createRxCollectionWithBoundaryCallback(factory: DataSource.Factory<Int, T>,
                                                         callback: BoundaryCallback<T>,
                                                         initialLoadKey: Int): Flowable<PagedList<T>> {
        return createRxCollectionWithBoundaryCallback(factory, callback, initialLoadKey, false)
    }

    fun <T : Any> createRxCollectionWithBoundaryCallback(factory: DataSource.Factory<Int, T>,
                                                         callback: BoundaryCallback<T>,
                                                         initialLoadKey: Int,
                                                         enablePlaceholders: Boolean): Flowable<PagedList<T>> {
        return createRxCollectionBuilder(factory, enablePlaceholders)
                .setBoundaryCallback(callback)
                .setInitialLoadKey(initialLoadKey)
                .buildFlowable(BackpressureStrategy.BUFFER)
    }

}