package com.ekoapp.ekosdk

import android.os.Parcel
import co.amity.rxupload.FileProperties
import com.amity.socialcloud.sdk.socket.util.EkoGson
import kotlinx.android.parcel.Parceler


object FilePropertiesParceler : Parceler<FileProperties?> {

    override fun create(parcel: Parcel): FileProperties? {
        return parcel.readString()?.let {
            EkoGson.get().fromJson(it, FileProperties::class.java)
        }
    }

    override fun FileProperties?.write(parcel: Parcel, flags: Int) {
        if (this != null) {
            parcel.writeString(EkoGson.get().toJson(this))
        }
    }
}