package com.ekoapp.ekosdk

import android.os.Parcel
import com.google.gson.JsonArray
import com.google.gson.JsonParser
import kotlinx.android.parcel.Parceler


object JsonArrayParceler : Parceler<JsonArray?> {

    override fun create(parcel: Parcel): JsonArray? {
        return parcel.readString()?.let {
            JsonParser().parse(it).asJsonArray
        }
    }

    override fun JsonArray?.write(parcel: Parcel, flags: Int) {
        if (this != null) {
            parcel.writeString(this.toString())
        }
    }

}