package com.amity.socialcloud.sdk.core

import android.os.Parcel
import com.google.gson.JsonObject
import com.google.gson.JsonParser
import kotlinx.android.parcel.Parceler


object JsonObjectParceler : Parceler<JsonObject?> {

    override fun create(parcel: Parcel): JsonObject? {
        return parcel.readString()?.let {
            JsonParser().parse(it).asJsonObject
        }
    }

    override fun JsonObject?.write(parcel: Parcel, flags: Int) {
        if (this != null) {
            parcel.writeString(this.toString())
        }
    }

}