package com.ekoapp.ekosdk

import androidx.room.Entity
import androidx.room.Ignore
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.core.file.AmityImage
import com.amity.socialcloud.sdk.core.permission.AmityPermissions
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.ekoapp.ekosdk.internal.EkoFileEntity
import com.ekoapp.ekosdk.internal.mapper.AmityFilePropertiesMapper
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.amity.types.ObjectId

@Entity(tableName = "user")
open class UserEntity(
    @PrimaryKey
    var userId: String = ObjectId.get().toHexString(),
    var mid: String = "",
    var path: String = "",
    var displayName: String? = null,
    var roles: AmityRoles? = null,
    var permissions: AmityPermissions? = null,
    var flagCount: Int = 0,
    var metadata: JsonObject? = null,
    var avatarFileId: String? = null,
    var avatarCustomUrl: String? = null,
    var description: String? = null,
    var isGlobalBan: Boolean = false,
    var isDeleted: Boolean = false
) : EkoObject() {

    override fun getId(): String {
        return userId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        if (other.javaClass != javaClass) return false
        return (Objects.equal(userId, (other as UserEntity).userId)
                && Objects.equal(mid, other.mid)
                && Objects.equal(path, other.path)
                && Objects.equal(displayName, other.displayName)
                && Objects.equal(roles, other.roles)
                && Objects.equal(permissions, other.permissions)
                && Objects.equal(flagCount, other.flagCount)
                && Objects.equal(metadata, other.metadata)
                && Objects.equal(avatarFileId, other.avatarFileId)
                && Objects.equal(avatarCustomUrl, other.avatarCustomUrl)
                && Objects.equal(description, other.description)
                && Objects.equal(isGlobalBan, other.isGlobalBan))
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            userId,
            mid,
            path,
            displayName,
            roles,
            permissions,
            flagCount,
            metadata,
            avatarFileId,
            avatarCustomUrl,
            description,
            isGlobalBan
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper): String {
        toStringHelper.add("userId", userId)
            .add("mid", mid)
            .add("path", path)
            .add("displayName", displayName)
            .add("roles", roles)
            .add("permissions", permissions)
            .add("flagCount", flagCount)
            .add("metadata", metadata)
            .add("avatarFileId", avatarFileId)
            .add("avatarCustomUrl", avatarCustomUrl)
            .add("description", description)
            .add("isGlobalBan", isGlobalBan)
        return super.internalToString(toStringHelper)
    }

}
