package com.amity.socialcloud.sdk.extension.adapter

import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.RecyclerView
import com.amity.socialcloud.sdk.chat.channel.AmityChannel
import com.google.common.base.Objects

abstract class AmityChannelAdapter<VH : RecyclerView.ViewHolder> : AmityPagedListAdapter<AmityChannel, VH> {
    constructor() : super(DIFF_CALLBACK) {}
    constructor(diffUtil: DiffUtil.ItemCallback<AmityChannel>) : super(diffUtil) {}

    companion object {
        private val DIFF_CALLBACK: DiffUtil.ItemCallback<AmityChannel> = object : DiffUtil.ItemCallback<AmityChannel>() {
            override fun areItemsTheSame(oldAmityChannel: AmityChannel, newAmityChannel: AmityChannel): Boolean {
                return Objects.equal(oldAmityChannel.getChannelId(), newAmityChannel.getChannelId())
            }

            override fun areContentsTheSame(oldAmityChannel: AmityChannel, newAmityChannel: AmityChannel): Boolean {
                return (Objects.equal(oldAmityChannel.getChannelId(), newAmityChannel.getChannelId())
                        && Objects.equal(oldAmityChannel.getType(), newAmityChannel.getType())
                        && Objects.equal(oldAmityChannel.getDisplayName(), newAmityChannel.getDisplayName())
                        && Objects.equal(oldAmityChannel.getMetadata(), newAmityChannel.getMetadata())
                        && Objects.equal(oldAmityChannel.getMessageCount(), newAmityChannel.getMessageCount())
                        && Objects.equal(oldAmityChannel.isRateLimited(), newAmityChannel.isRateLimited())
                        && Objects.equal(oldAmityChannel.isMuted(), newAmityChannel.isMuted())
                        && Objects.equal(oldAmityChannel.getLastActivity(), newAmityChannel.getLastActivity())
                        && Objects.equal(oldAmityChannel.getMemberCount(), newAmityChannel.getMemberCount())
                        && Objects.equal(oldAmityChannel.getTags(), newAmityChannel.getTags())
                        && Objects.equal(oldAmityChannel.getUnreadCount(), newAmityChannel.getUnreadCount())
                        && Objects.equal(oldAmityChannel.isDeleted(), newAmityChannel.isDeleted()))
            }
        }
    }
}