package com.amity.socialcloud.sdk.extension.adapter

import androidx.paging.PagingDataAdapter
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.RecyclerView
import com.amity.socialcloud.sdk.social.comment.AmityComment
import com.google.common.base.Objects

abstract class AmityCommentAdapter<VH : RecyclerView.ViewHolder> : PagingDataAdapter<AmityComment, VH> {
    constructor() : super(DIFF_CALLBACK) {}
    constructor(diffUtil: DiffUtil.ItemCallback<AmityComment>) : super(diffUtil) {}

    companion object {
        private val DIFF_CALLBACK: DiffUtil.ItemCallback<AmityComment> = object : DiffUtil.ItemCallback<AmityComment>() {
            override fun areItemsTheSame(oldEkoPost: AmityComment, newEkoPost: AmityComment): Boolean {
                return oldEkoPost.getCommentId() == newEkoPost.getCommentId()
            }

            override fun areContentsTheSame(oldItem: AmityComment, newItem: AmityComment): Boolean {
                return (Objects.equal(oldItem.getCommentId(), newItem.getCommentId())
                        && Objects.equal(oldItem.getReference(), newItem.getReference())
                        && Objects.equal(oldItem.getParentId(), newItem.getParentId())
                        && Objects.equal(oldItem.getDataType(), newItem.getDataType())
                        && Objects.equal(oldItem.getChildrenNumber(), newItem.getChildrenNumber())
                        && Objects.equal(oldItem.getData(), newItem.getData())
                        && Objects.equal(oldItem.getFlagCount(), newItem.getFlagCount())
                        && Objects.equal(oldItem.getReactionMap(), newItem.getReactionMap())
                        && Objects.equal(oldItem.getReactionCount(), newItem.getReactionCount())
                        && Objects.equal(oldItem.getUser(), newItem.getUser())
                        && Objects.equal(oldItem.getState(), newItem.getState())
                        && Objects.equal(oldItem.isEdited(), newItem.isEdited()
                        && Objects.equal(oldItem.isDeleted(), newItem.isDeleted())))
            }
        }
    }
}