package com.amity.socialcloud.sdk.extension.adapter

import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.ListAdapter
import androidx.recyclerview.widget.RecyclerView
import com.amity.socialcloud.sdk.social.community.AmityCommunity
import com.google.common.base.Objects

abstract class AmityCommunityAdapter<VH : RecyclerView.ViewHolder> :
    ListAdapter<AmityCommunity, VH> {
    constructor() : super(DIFF_CALLBACK) {}
    constructor(diffUtil: DiffUtil.ItemCallback<AmityCommunity>) : super(diffUtil) {}

    companion object {
        private val DIFF_CALLBACK: DiffUtil.ItemCallback<AmityCommunity> = object : DiffUtil.ItemCallback<AmityCommunity>() {
            override fun areItemsTheSame(oldAmityCommunity: AmityCommunity, newAmityCommunity: AmityCommunity): Boolean {
                return Objects.equal(oldAmityCommunity.getCommunityId(), newAmityCommunity.getCommunityId())
            }

            override fun areContentsTheSame(oldAmityCommunity: AmityCommunity, newAmityCommunity: AmityCommunity): Boolean {
                return false
            }
        }
    }
}