package com.amity.socialcloud.sdk.extension.adapter

import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.RecyclerView
import com.amity.socialcloud.sdk.social.community.AmityCommunityCategory
import com.google.common.base.Objects

abstract class AmityCommunityCategoryAdapter<VH : RecyclerView.ViewHolder> : AmityPagedListAdapter<AmityCommunityCategory, VH> {
    constructor() : super(DIFF_CALLBACK) {}
    constructor(diffUtil: DiffUtil.ItemCallback<AmityCommunityCategory>) : super(diffUtil) {}

    companion object {
        val DIFF_CALLBACK: DiffUtil.ItemCallback<AmityCommunityCategory> = object : DiffUtil.ItemCallback<AmityCommunityCategory>() {
            override fun areItemsTheSame(oldAmityCommunityCategory: AmityCommunityCategory, newAmityCommunityCategory: AmityCommunityCategory): Boolean {
                return oldAmityCommunityCategory.getCategoryId() == newAmityCommunityCategory.getCategoryId()
            }

            override fun areContentsTheSame(oldAmityCommunityCategory: AmityCommunityCategory, newAmityCommunityCategory: AmityCommunityCategory): Boolean {
                return (Objects.equal(oldAmityCommunityCategory.getCategoryId(), newAmityCommunityCategory.getCategoryId())
                        && Objects.equal(oldAmityCommunityCategory.getName(), newAmityCommunityCategory.getName())
                        && Objects.equal(oldAmityCommunityCategory.getMetadata(), newAmityCommunityCategory.getMetadata())
                        && Objects.equal(oldAmityCommunityCategory.getAvatar(), newAmityCommunityCategory.getAvatar())
                        && Objects.equal(oldAmityCommunityCategory.getUpdatedAt(), newAmityCommunityCategory.getUpdatedAt()))
            }
        }
    }
}