package com.amity.socialcloud.sdk.extension.adapter

import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.RecyclerView
import com.amity.socialcloud.sdk.social.community.AmityCommunityMember
import com.google.common.base.Objects

abstract class AmityCommunityMembershipAdapter<VH : RecyclerView.ViewHolder> : AmityPagedListAdapter<AmityCommunityMember, VH>(DIFF_CALLBACK) {
    companion object {
        private val DIFF_CALLBACK: DiffUtil.ItemCallback<AmityCommunityMember> = object : DiffUtil.ItemCallback<AmityCommunityMember>() {
            override fun areItemsTheSame(oldChannelMember: AmityCommunityMember, newChannelMember: AmityCommunityMember): Boolean {
                return Objects.equal(oldChannelMember.getUserId(), newChannelMember.getUserId())
            }

            override fun areContentsTheSame(oldCommunityMember: AmityCommunityMember, newCommunityMember: AmityCommunityMember): Boolean {
                return (Objects.equal(oldCommunityMember.getCommunityId(), newCommunityMember.getCommunityId())
                        && Objects.equal(oldCommunityMember.getUserId(), newCommunityMember.getUserId())
                        && Objects.equal(oldCommunityMember.getChannelId(), newCommunityMember.getChannelId())
                        && Objects.equal(oldCommunityMember.isBanned(), newCommunityMember.isBanned())
                        && Objects.equal(oldCommunityMember.getUser(), newCommunityMember.getUser())
                        && Objects.equal(oldCommunityMember.getRoles(), newCommunityMember.getRoles()))
            }
        }
    }
}