package com.amity.socialcloud.sdk.extension.adapter

import androidx.paging.PagingDataAdapter
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.RecyclerView
import com.amity.socialcloud.sdk.chat.message.AmityMessage
import com.google.common.base.Objects

abstract class AmityMessageAdapter<VH : RecyclerView.ViewHolder> : PagingDataAdapter<AmityMessage, VH> {
    constructor() : super(DIFF_CALLBACK) {}
    constructor(diffUtil: DiffUtil.ItemCallback<AmityMessage>) : super(diffUtil) {}

    companion object {
        private val DIFF_CALLBACK: DiffUtil.ItemCallback<AmityMessage> = object : DiffUtil.ItemCallback<AmityMessage>() {
            override fun areItemsTheSame(oldAmityMessage: AmityMessage, newAmityMessage: AmityMessage): Boolean {
                return Objects.equal(oldAmityMessage.getMessageId(), newAmityMessage.getMessageId())
            }

            override fun areContentsTheSame(oldAmityMessage: AmityMessage, newAmityMessage: AmityMessage): Boolean {
                return (Objects.equal(oldAmityMessage.getMessageId(), newAmityMessage.getMessageId())
                        && Objects.equal(oldAmityMessage.getChannelId(), newAmityMessage.getChannelId())
                        && Objects.equal(oldAmityMessage.getUserId(), newAmityMessage.getUserId())
                        && Objects.equal(oldAmityMessage.getParentId(), newAmityMessage.getParentId())
                        && Objects.equal(oldAmityMessage.getDataType(), newAmityMessage.getDataType())
                        && Objects.equal(oldAmityMessage.getChannelSegment(), newAmityMessage.getChannelSegment())
                        && Objects.equal(oldAmityMessage.getChildrenNumber(), newAmityMessage.getChildrenNumber())
                        && Objects.equal(oldAmityMessage.getEditedAt(), newAmityMessage.getEditedAt())
                        && Objects.equal(oldAmityMessage.getData(), newAmityMessage.getData())
                        && Objects.equal(oldAmityMessage.isDeleted(), newAmityMessage.isDeleted())
                        && Objects.equal(oldAmityMessage.getReadByCount(), newAmityMessage.getReadByCount())
                        && Objects.equal(oldAmityMessage.getFlagCount(), newAmityMessage.getFlagCount())
                        && Objects.equal(oldAmityMessage.getTags(), newAmityMessage.getTags())
                        && Objects.equal(oldAmityMessage.getUser(), newAmityMessage.getUser())
                        && Objects.equal(oldAmityMessage.getState(), newAmityMessage.getState())
                        && Objects.equal(oldAmityMessage.getReactionMap(), newAmityMessage.getReactionMap())
                        && Objects.equal(oldAmityMessage.getReactionCount(), newAmityMessage.getReactionCount()))
            }
        }
    }
}