package com.amity.socialcloud.sdk.extension.adapter

import android.os.Build
import android.os.Handler
import android.os.Looper
import androidx.paging.AsyncPagedListDiffer
import androidx.paging.PagedListAdapter
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.RecyclerView
import java.lang.reflect.InvocationTargetException
import java.util.concurrent.Executor

abstract class AmityPagedListAdapter<T : Any, VH : RecyclerView.ViewHolder>(diffCallback: DiffUtil.ItemCallback<T>) : PagedListAdapter<T, VH>(diffCallback) {
    private fun createAsync(looper: Looper): Handler {

        if (Build.VERSION.SDK_INT >= 28) {
            return Handler.createAsync(looper)
        }
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                return Handler::class.java.getDeclaredConstructor(Looper::class.java,
                        Handler.Callback::class.java,
                        Boolean::class.javaPrimitiveType)
                        .newInstance(looper, null, true)
            } catch (ignored: NoSuchMethodException) {
                ignored.printStackTrace()
            } catch (ignored: IllegalAccessException) {
                ignored.printStackTrace()
            } catch (ignored: InstantiationException) {
                ignored.printStackTrace()
            } catch (e: InvocationTargetException) {
                e.printStackTrace()
                return Handler(looper)
            }
        }
        return Handler(looper)
    }

    // Hot fix for indexOutOfBound issue
    // https://stackoverflow.com/questions/55546116/room-livedata-with-paging-getting-indexoutofboundsexception-in-some-devices/56873666#56873666
    init {
        try {
            val mDiffer = PagedListAdapter::class.java.getDeclaredField("mDiffer")
            val executor = AsyncPagedListDiffer::class.java.getDeclaredField("mMainThreadExecutor")
            mDiffer.isAccessible = true
            executor.isAccessible = true
            val myDiffer = mDiffer[this] as AsyncPagedListDiffer<*>
            val foreground: Executor = object : Executor {
                val handler = createAsync(Looper.getMainLooper())
                override fun execute(command: Runnable) {
                    try {
                        handler.post {
                            try {
                                command.run()
                            } catch (e: Exception) {
                                e.printStackTrace()
                            }
                        }
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                }
            }
            executor[myDiffer] = foreground
        } catch (e: NoSuchFieldException) {
            e.printStackTrace()
        } catch (e: IllegalAccessException) {
            e.printStackTrace()
        } catch (e: IllegalArgumentException) {
            e.printStackTrace()
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }
}