package com.amity.socialcloud.sdk.extension.adapter

import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.RecyclerView
import com.amity.socialcloud.sdk.social.feed.AmityPost
import com.google.common.base.Objects

abstract class AmityPostAdapter<VH : RecyclerView.ViewHolder> : AmityPagedListAdapter<AmityPost, VH> {
    constructor() : super(DIFF_CALLBACK) {}
    constructor(diffUtil: DiffUtil.ItemCallback<AmityPost>) : super(diffUtil) {}

    companion object {
        private val DIFF_CALLBACK: DiffUtil.ItemCallback<AmityPost> = object : DiffUtil.ItemCallback<AmityPost>() {
            override fun areItemsTheSame(oldAmityPost: AmityPost, newAmityPost: AmityPost): Boolean {
                return oldAmityPost.getPostId() == newAmityPost.getPostId()
            }

            override fun areContentsTheSame(oldAmityPost: AmityPost, newAmityPost: AmityPost): Boolean {
                return (Objects.equal(oldAmityPost.getPostId(), newAmityPost.getPostId())
                        && Objects.equal(oldAmityPost.getPostedUser(), newAmityPost.getPostedUser())
                        && Objects.equal(oldAmityPost.getSharedCount(), newAmityPost.getSharedCount())
                        && Objects.equal(oldAmityPost.getData(), newAmityPost.getData())
                        && Objects.equal(oldAmityPost.getChildren(), newAmityPost.getChildren())
                        && Objects.equal(oldAmityPost.getReactions(), newAmityPost.getReactions())
                        && Objects.equal(oldAmityPost.getReactionCount(), newAmityPost.getReactionCount())
                        && Objects.equal(oldAmityPost.getFlagCount(), newAmityPost.getFlagCount())
                        && Objects.equal(oldAmityPost.getEditedAt(), newAmityPost.getEditedAt())
                        && Objects.equal(oldAmityPost.getCreatedAt(), newAmityPost.getCreatedAt())
                        && Objects.equal(oldAmityPost.getUpdatedAt(), newAmityPost.getUpdatedAt()))
            }
        }
    }
}