package com.amity.socialcloud.sdk.extension.adapter

import androidx.paging.PagingDataAdapter
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.RecyclerView
import com.amity.socialcloud.sdk.core.reaction.AmityReaction
import com.google.common.base.Objects

abstract class AmityReactionPagingAdapter<VH : RecyclerView.ViewHolder> :
    PagingDataAdapter<AmityReaction, VH> {
    constructor() : super(DIFF_CALLBACK) {}
    constructor(diffUtil: DiffUtil.ItemCallback<AmityReaction>) : super(diffUtil) {}

    companion object {
        private val DIFF_CALLBACK: DiffUtil.ItemCallback<AmityReaction> =
            object : DiffUtil.ItemCallback<AmityReaction>() {
                override fun areItemsTheSame(
                    oldItem: AmityReaction,
                    newItem: AmityReaction
                ): Boolean {
                    return (Objects.equal(oldItem.getReference(), newItem.getReference())
                            && Objects.equal(oldItem.getUserId(), newItem.getUserId())
                            && Objects.equal(oldItem.getReactionName(), newItem.getReactionName()))
                }

                override fun areContentsTheSame(
                    oldItem: AmityReaction,
                    newItem: AmityReaction
                ): Boolean {
                    return (Objects.equal(oldItem.getReference(), newItem.getReference())
                            && Objects.equal(oldItem.getUserId(), newItem.getUserId())
                            && Objects.equal(oldItem.getReactionName(), newItem.getReactionName())
                            && Objects.equal(
                        oldItem.getUserDisplayName(),
                        newItem.getUserDisplayName()
                    ))
                }
            }
    }
}