package com.amity.socialcloud.sdk.extension.adapter

import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.RecyclerView
import com.amity.socialcloud.sdk.core.user.AmityUser
import com.google.common.base.Objects

abstract class AmityUserAdapter<VH : RecyclerView.ViewHolder> : AmityPagedListAdapter<AmityUser, VH> {
    constructor() : super(DIFF_CALLBACK) {}
    constructor(diffUtil: DiffUtil.ItemCallback<AmityUser>) : super(diffUtil) {}

    companion object {
        val DIFF_CALLBACK: DiffUtil.ItemCallback<AmityUser> = object : DiffUtil.ItemCallback<AmityUser>() {
            override fun areItemsTheSame(oldAmityUser: AmityUser, newAmityUser: AmityUser): Boolean {
                return oldAmityUser.getUserId() == newAmityUser.getUserId()
            }

            override fun areContentsTheSame(oldAmityUser: AmityUser, newAmityUser: AmityUser): Boolean {
                return (Objects.equal(oldAmityUser.getUserId(), newAmityUser.getUserId())
                        && Objects.equal(oldAmityUser.getDisplayName(), newAmityUser.getDisplayName())
                        && Objects.equal(oldAmityUser.getMetadata(), newAmityUser.getMetadata())
                        && Objects.equal(oldAmityUser.getRoles(), newAmityUser.getRoles())
                        && Objects.equal(oldAmityUser.getFlagCount(), newAmityUser.getFlagCount())
                        && Objects.equal(oldAmityUser.getUpdatedAt(), newAmityUser.getUpdatedAt()))
            }
        }
    }
}