package com.amity.socialcloud.sdk.chat.channel

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.core.file.AmityImage
import com.ekoapp.ekosdk.ReactorObject
import com.ekoapp.ekosdk.channel.message.query.AmityChannelLatestMessageQuery
import com.google.gson.JsonObject
import kotlinx.android.parcel.Parcelize
import kotlinx.android.parcel.TypeParceler
import org.amity.types.ObjectId
import org.joda.time.DateTime


@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityChannel internal constructor(
        private val channelId: String,
        private val displayName: String,
        private val metadata: JsonObject? = null,
        private val messageCount: Int,
        private val isRateLimited: Boolean,
        private val isMuted: Boolean,
        private val lastActivity: DateTime,
        private val memberCount: Int,
        private val moderatorMemberCount: Int,
        private val tags: AmityTags,
        internal var unreadCount: Int = 0,
        internal var hasUnreadMention: Boolean = false,
        private val type: Type,
        internal val avatarFileId: String? = null,
        internal var avatar: AmityImage? = null,
        private val isDeleted: Boolean,
        private val createdAt: DateTime,
        private val updatedAt: DateTime
) : Parcelable, ReactorObject {

    fun getChannelId(): String {
        return channelId
    }

    fun getType(): Type {
        return type
    }

    fun getDisplayName(): String {
        return displayName
    }

    fun getMetadata(): JsonObject? {
        return metadata
    }

    fun getMessageCount(): Int {
        return messageCount
    }

    fun getMemberCount(): Int {
        return memberCount
    }
    
    fun getModeratorMemberCount(): Int {
        return moderatorMemberCount
    }

    fun getUnreadCount(): Int {
        return unreadCount
    }

    fun isRateLimited(): Boolean {
        return isRateLimited
    }

    fun isMuted(): Boolean {
        return isMuted
    }

    fun getLastActivity(): DateTime? {
        return lastActivity
    }

    fun getTags(): AmityTags {
        return tags
    }

    fun getAvatar(): AmityImage? {
        return avatar
    }

    fun isDeleted(): Boolean? {
        return isDeleted
    }

    fun getCreatedAt(): DateTime? {
        return createdAt
    }

    fun getUpdatedAt(): DateTime? {
        return updatedAt
    }

    fun hasUnreadMention(): Boolean {
        return hasUnreadMention
    }

    fun membership(): AmityChannelParticipation {
        return AmityChannelParticipation(getChannelId())
    }

    fun moderation(): AmityChannelModeration {
        return AmityChannelModeration(getChannelId())
    }

    fun notification(): AmityChannelNotification {
        return AmityChannelNotification(getChannelId())
    }

    fun latestMessage(): AmityChannelLatestMessageQuery.Builder {
        return AmityChannelLatestMessageQuery.Builder(getChannelId())
    }

    override fun updatedAt(): DateTime? {
        return updatedAt
    }

    override fun uniqueId(): String {
        return channelId
    }

    enum class Type(val apiKey: String) {
        COMMUNITY("community"),
        LIVE("live"),
        BROADCAST("broadcast"),
        CONVERSATION("conversation"),
        @Deprecated(message = "This channel type is deprecated")
        STANDARD("standard"),
        @Deprecated(message = "This channel type is deprecated")
        PRIVATE("private"), ;

        companion object {
            fun enumOf(value: String?): Type {
                return values().find { it.apiKey == value } ?: COMMUNITY
            }
        }
    }

}