package com.amity.socialcloud.sdk.chat.channel

import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.core.file.AmityImage
import com.google.gson.JsonObject
import org.joda.time.DateTime

interface AmityChannelContract {

    fun getChannelId(): String
    fun getType(): AmityChannel.Type
    fun getDisplayName(): String
    fun getMetadata(): JsonObject?
    fun getMessageCount(): Int
    fun getMemberCount(): Int
    fun getUnreadCount(): Int
    fun isRateLimited(): Boolean
    fun isMuted(): Boolean
    fun getLastActivity(): DateTime?
    fun getTags(): AmityTags
    fun getAvatar(): AmityImage?
    fun isDeleted(): Boolean?
    fun getCreatedAt(): DateTime?
    fun getUpdatedAt(): DateTime?
    fun hasUnreadMention(): Boolean

}