package com.amity.socialcloud.sdk.chat.channel

import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.core.file.AmityImage
import com.google.gson.JsonObject

class AmityCommunityChannelWithChannelId {
    class Builder(private val channelId: String) {
        private var displayName: String? = null
        private var avatarFileId: String? = null
        private var metadata: JsonObject? = null
        private var tags: AmityTags? = null
        private var userIds: List<String>? = null

        fun displayName(displayName: String): Builder {
            return apply { this.displayName = displayName }
        }

        fun avatar(avatar: AmityImage): Builder {
            return apply { this.avatarFileId = avatar.getFileId() }
        }

        fun metadata(metadata: JsonObject): Builder {
            return apply { this.metadata = metadata }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun userIds(userIds: List<String>): Builder {
            return apply { this.userIds = userIds }
        }

        fun build(): AmityChannelCreator {
            val option = ChannelCreateOption(
                    displayName = displayName,
                    metadata = metadata,
                    avatarFileId = avatarFileId,
                    tags = tags,
                    userIds = userIds)

            return AmityChannelCreator(
                    channelType = AmityChannelCreator.CreationType.COMMUNITY,
                    channelId = channelId,
                    option = option)
        }
    }
}