package com.amity.socialcloud.sdk.chat.channel

import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.core.file.AmityImage
import com.google.gson.JsonObject

class AmityConversationChannel {
    class Builder(private val userId: String) {
        private var displayName: String? = null
        private var avatarFileId: String? = null
        private var metadata: JsonObject? = null
        private var tags: AmityTags? = null

        fun displayName(displayName: String): Builder {
            return apply { this.displayName = displayName }
        }

        fun avatar(avatar: AmityImage): Builder {
            return apply { this.avatarFileId = avatar.getFileId() }
        }

        fun metadata(metadata: JsonObject): Builder {
            return apply { this.metadata = metadata }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun build(): AmityChannelCreator {
            val option = ChannelCreateOption(
                    displayName = displayName,
                    avatarFileId = avatarFileId,
                    metadata = metadata,
                    tags = tags,
                    userIds = listOf(userId))
            return AmityChannelCreator(channelType = AmityChannelCreator.CreationType.CONVERSATION,
                    option = option)
        }
    }
}