package com.amity.socialcloud.sdk.chat.channel

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.core.permission.AmityPermissions
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.amity.socialcloud.sdk.core.user.AmityMembershipType
import com.amity.socialcloud.sdk.core.user.AmityUser
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonObject
import kotlinx.android.parcel.Parcelize
import kotlinx.android.parcel.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityChannelMember internal constructor(
    private val userId: String,
    private val channelId: String,
    private val isMuted: Boolean,
    private val isBanned: Boolean,
    private val roles: AmityRoles,
    private val permissions: AmityPermissions,
    private val createdAt: DateTime,
    private val updatedAt: DateTime,
    internal var user: AmityUser? = null
) : Parcelable, ReactorObject {

    fun getUserId(): String {
        return userId
    }

    fun getChannelId(): String {
        return channelId
    }

    fun isMuted(): Boolean {
        return isMuted
    }

    fun isBanned(): Boolean {
        return isBanned
    }

    fun getRoles(): AmityRoles {
        return roles
    }

    fun getUser(): AmityUser? {
        return user
    }

    override fun updatedAt(): DateTime? {
        return updatedAt
    }

    override fun uniqueId(): String {
        return channelId
    }

}