package com.amity.socialcloud.sdk.chat.channel

import com.amity.socialcloud.sdk.AmityCoreClient
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.channel.AddUsersChannelParticipationUseCase
import com.ekoapp.ekosdk.internal.usecase.channel.GetChannelMemberUseCase
import com.ekoapp.ekosdk.internal.usecase.channel.RemoveUsersChannelParticipationUseCase
import com.ekoapp.ekosdk.internal.usecase.channel.StartReadingChannelParticipationUseCase
import com.ekoapp.ekosdk.internal.usecase.channel.StopReadingChannelParticipationUseCase
import io.reactivex.Flowable
import io.reactivex.Single

class AmityChannelParticipation(private val channelId: String) {

    fun getMyMembership() : Flowable<AmityChannelMember> {
        return GetChannelMemberUseCase().execute(channelId, AmityCoreClient.getUserId()).toV2()
    }

    fun getMembers(): AmityChannelMembershipQuery.Builder{
        return AmityChannelMembershipQuery.Builder(channelId)
    }

    fun searchMembers(keyword: String): AmityChannelMemberSearch.Builder {
        return AmityChannelMemberSearch.Builder(channelId, keyword)
    }

    fun addMembers(userIds: List<String>): Single<AmityChannel> {
        return AddUsersChannelParticipationUseCase().execute(channelId, userIds).toV2()
    }

    fun removeMembers(userIds: List<String>): Single<AmityChannel> {
        return RemoveUsersChannelParticipationUseCase().execute(channelId, userIds).toV2()
    }

    fun startReading() {
        return StartReadingChannelParticipationUseCase().execute(channelId)
    }

    fun stopReading() {
        return StopReadingChannelParticipationUseCase().execute(channelId)
    }

}