package com.amity.socialcloud.sdk.core.user

enum class AmityMembershipType(val apiKey: String) {
    MEMBER("member"), BANNED("banned"), NONE("none");

    companion object {
        fun enumOf(apiKey: String) : AmityMembershipType {
            return values().find { it.apiKey == apiKey } ?: NONE
        }
    }

}