package com.amity.socialcloud.sdk.chat.channel


import com.amity.socialcloud.sdk.log.AmityLog
import com.google.common.base.Objects

enum class AmityChannelMembership(val apiKey: String) {
    MEMBER("member"),
    MUTED("muted"),
    BANNED("banned");

    companion object {

        @Deprecated("use enumOf() instead")
        @JvmStatic
        fun fromApiKey(apiKey: String?): AmityChannelMembership {
            for (filter in values()) {
                if (Objects.equal(apiKey, filter.apiKey)) {
                    return filter
                }
            }
            AmityLog.e(Exception(), "unknown api key : %s of channel membership filter", apiKey)
            return MEMBER
        }

        fun enumOf(apiKey: String): AmityChannelMembership {
            return values().find {
                it.apiKey == apiKey
            } ?: MEMBER
        }
    }

}